function main(self)
    if self.State == 0 then
		self.Flags.AlwaysActive, self.DrawFlags.NoDraw = true, true
		self.cooldown = 0
		self.emptySoundDelay = 0
		self.fireSoundDelay = 0
		local isMultiPlayer = GetGameType() == GameType.MultiPlayer
		self.detector = GetObject(3206)
		local width = self.detector.ScreenW
		self.hud = CreateHUDObject{
			X = width - 23,
			Y = isMultiPlayer and 72 or 98,
			Z = 10050,
			Logic = "AniCycle",
			Image = "CUSTOM_INTERFACE_FS",
			Animation = "GAME_CYCLE200"
		}
		self.hudNumber1 = CreateHUDObject{
			X = width - 39,
			Y = isMultiPlayer and 73 or 99,
			Z = 10051,
			Logic = "DoNothing",
			Image = "CUSTOM_INTERFACE_SMALLNUMBERS"
		}
		self.hudNumber2 = CreateHUDObject{
			X = width - 31,
			Y = isMultiPlayer and 73 or 99,
			Z = 10051,
			Logic = "DoNothing",
			Image = "CUSTOM_INTERFACE_SMALLNUMBERS"
		}
		self.State = 1
	end

    -- Handle interface:
	if self.State > 0 then
		local cooldown = math.floor((self.cooldown-GetTime())/1000)
		if self.State == 1 then
			self.hudNumber1:SetFrame(2)
			self.hudNumber2:SetFrame(0)
		elseif self.State == 2 then
			self.hudNumber1:SetFrame(math.floor((cooldown-40)/10))
			self.hudNumber2:SetFrame((cooldown-40)%10)
        else
            self.hudNumber1:SetFrame(math.floor(cooldown/10))
			self.hudNumber2:SetFrame(cooldown%10)
		end
	end

	-- Activate:
	if self.State == 1 and GetInput"Special" then
		local claw = GetClaw()
		local fireball = "ArtifactPower:FireShieldBall"
		self.fireball1 = CreateObject{X = claw.X, Y = claw.Y, Z = 6100, name = fireball, Speed = 180, Points = 0, Width = 80}
		self.fireball2 = CreateObject{X = claw.X, Y = claw.Y, Z = 6100, name = fireball, Speed = 180, Points = 120, Width = 80}
		self.fireball3 = CreateObject{X = claw.X, Y = claw.Y, Z = 6100, name = fireball, Speed = 180, Points = 240, Width = 80}
		self.cooldown = GetTime() + 60000
		self.emptySoundDelay = GetTime() + 20000
		self.State = 2
	end

	-- In work:
	if self.State == 2 then
		if GetTime() > self.cooldown - 40000 or GetClaw().Health <= 0 then
			self.fireball1:Destroy()
			self.fireball2:Destroy()
			self.fireball3:Destroy()
			self.State = 3
		end
		if GetTime() > self.fireSoundDelay then
			PlaySound("CUSTOM_FIRESHIELD")
			self.fireSoundDelay = GetTime() + 3400
		end
	end

	-- Cooldown:
	if self.State == 3 then
		if GetTime() > self.cooldown then
			self.State = 1
		end
		if GetInput"Special" and GetTime() > self.emptySoundDelay then
			PlaySound("CLAW_EMPTYMAGIC")
			self.emptySoundDelay = GetTime() + 2000
		end
	end

end



